<!-- Start of HV Slider stack v%stackVersion% -->
%[if edit]%<div class="atm_stackElement_%id%">
	<div class="atm_stackElementLabel_%id%">HV Slider stack <span class="atm_stackElementVersion_%id%">v%stackVersion% (by Henk Vrieselaar and Tsooj Media)</span>
	</div>
	<div class="atm_stackElementInstructions_%id%"><div class="atm_stackElementInstructionsLabel_%id%">Instructions:</div>Use the Stacks plugin sidepane to set the slideshow properties. Select the first slideshow image from a RW resource folder. You can always (manually) upload more files into that resource folder. Images should remain on the same webserver as the page showing the slideshow and only jpeg and png file formats are supported. Note that you need to Publish your website before you are able to see the Slideshow that is relying on PHP 5.3+ for the creation of the Slideshow.<br /><br /><div class="atm_stackElementInstructionsLabel_%id%">You can use the following basic EXIF/IPTC+ placeholders for your Image Captions:</div>#exifWidth#, #exifHeight#, #exifAperture#, #exifApertureNumber#, #exifMake#, #exifModel#, #exifDateTime#, #exifExposureTime#, #exifExposureTime#, #exifISO#, #exifDateTimeOriginal#, #exifExposureBiasValue#, #exifMeteringMode#, #exifFlash#, #exifExposureMode#, #exifWhiteBalance#, #exifLens#, #exifOwnerName#, #exifFocalLength#, #exifCopyright#, #iptcDocumentTitle#, #iptcUrgency#, #iptcCategory#, #iptcSpecialInstructions#, #iptcCreationDate#, #iptcCreationTime#, #iptcAuthor#, #iptcAuthorTitle#, #iptcCity#, #iptcState#, #iptcCountry#, #iptcOTR#, #iptcHeadline#, #iptcCredit#, #iptcSource#, #iptcCopyright#, #iptcCaption#, #iptcCaptionWriter#, #year#, #month#, #day#, #hours#, #minutes#, #seconds#, #customDate#, #fileName#</div>
	<div class="atm_stackElementSidePaneValue_%id%"><span class="atm_stackElementSidePaneValueLabel">Your Caption Format: </span>%id=imagesCaption%</div>
	<div class="atm_stackElementSidePaneValue_%id%"><span class="atm_stackElementSidePaneValueLabel">Custom Date Format: </span>%id=imagesCaptionCustomDate%</div>
	<div class="atm_stackElementClearer_%id%"></div>
	</div>
</div>%[endif]%%[if !edit]%%[if publish]%
%[if %("%id=phpCheckRequirements%"=="disabled")%]%<?php 

// Get Main Images Folder based on first selected image in the resources folder.
// Direct selection of folder path not possible with current RW link dialog or too challenging as a direct input for most users.
// Note that RW 6.0.9- is not correctly setting the resource reference from within subfolder level 3 and lower, reported to RMS March 2015.
$hvSliderMainImagesFolder_%id% = "";
$hvSliderSlides_%id% = "";

if (function_exists('pathinfo')) {
	$hvSliderMainImagesFolder_%id% = pathinfo("./%id=imagesFolder -href%", PATHINFO_DIRNAME);
	$hvSliderMainImagesFolder_%id% = rtrim($hvSliderMainImagesFolder_%id%, '/') . '/';
	
	// Get All Images matching the patters for supported image files.
	if (function_exists('glob')) {
		$hvSliderImages_%id% = glob($hvSliderMainImagesFolder_%id% . "*.{jpg,JPG,jpeg,JPEG,png,PNG}", GLOB_BRACE);
		
		// Build Image Slides String.
		foreach($hvSliderImages_%id% as $image) {
			// Get the Filename and set basic Image Caption variables.
			$slideTitle = "%id=imagesCaption%";
			$imageData = array();
			$imageData["#fileName#"] = pathinfo($image, PATHINFO_FILENAME);
			
			// Fill Image Data Array with IPTC information.	
			if (function_exists('getimagesize') && function_exists('iptcparse')) {
				$size = getimagesize($image, $imageInfo);
				if(isset($imageInfo['APP13'])) {
					$iptc = iptcparse($imageInfo["APP13"]);
					 if (is_array($iptc)) { 	
						// Supported Known IPTC Elements.
						$imageData["#iptcDocumentTitle#"] = $iptc['2#005'][0];
						$imageData["#iptcUrgency#"] = $iptc['2#010'][0];
						$imageData["#iptcCategory#"] = $iptc['2#015'][0];
						$imageData["#iptcSpecialInstructions#"] = $iptc['2#040'][0];
						$imageData["#iptcCreationDate#"] = $iptc['2#055'][0];
						$imageData["#iptcCreationTime#"] = $iptc['2#060'][0];
						$imageData["#iptcAuthor#"] = $iptc["2#080"][0];
						$imageData["#iptcAuthorTitle#"] = $iptc["2#085"][0];
						$imageData["#iptcCity#"] = $iptc["2#090"][0];
						$imageData["#iptcState#"] = $iptc["2#095"][0];
						$imageData["#iptcCountry#"] = $iptc["2#101"][0];
						$imageData["#iptcOTR#"] = $iptc["2#103"][0];
						$imageData["#iptcHeadline#"] = $iptc["2#105"][0];
						$imageData["#iptcCredit#"] = $iptc["2#110"][0];
						$imageData["#iptcSource#"] = $iptc["2#115"][0];
						$imageData["#iptcCopyright#"] = $iptc["2#116"][0];
						$imageData["#iptcCaption#"] = $iptc["2#120"][0];
						$imageData["#iptcCaptionWriter#"] = $iptc["2#122"][0];
								 	
					 	// Custom Date Formats based on IPTC.
						$imageData["#year#"] = substr($imageData["#iptcCreationDate#"], 0, 4);
						$imageData["#month#"] = substr($imageData["#iptcCreationDate#"], 4, 2);
						$imageData["#day#"] = substr($imageData["#iptcCreationDate#"], -2);
						$imageData["#hours#"] = substr($imageData["#iptcCreationTime#"], 0,2);
						$imageData["#minutes#"] = substr($imageData["#iptcCreationTime#"], 2,2);
						$imageData["#minutes#"] = substr($imageData["#iptcCreationTime#"], 4,2);			
						$imageData["#customDate#"] = @date('%id=imagesCaptionCustomDate%', mktime($imageData["#hours#"], $imageData["#minutes#"], $imageData["#minutes#"], $imageData["#month#"], $imageData["#day#"], $imageData["#year#"]));	 		
					}
				}
			}
			
			// Fill Image Data Array with EXIF information.
			if (function_exists('read_exif_data')) {
				$exif = read_exif_data($image, 0, true);
				if(is_array($exif)) {
					$imageData["#exifHeight#"] = $exif['COMPUTED']['Height'];
					$imageData["#exifWidth#"] = $exif['COMPUTED']['Width'];
					$imageData["#exifAperture#"] = $exif['COMPUTED']['ApertureFNumber'];
					$imageData["#exifApertureNumber#"] = $exif['EXIF']['FNumber'];
					$imageData["#exifMake#"] = $exif['IFD0']['Make'];
					$imageData["#exifModel#"] = str_replace($make,'',$exif['IFD0']['Model']);
					$imageData["#exifDateTime#"] = $exif['IFD0']['DateTime'];
					$imageData["#exifExposureTime#"] = $exif['EXIF']['ExposureTime'].' Seconds';
					$imageData["#exifISO#"] = $exif['EXIF']['ISOSpeedRatings'];
					$imageData["#exifDateTimeOriginal#"] = $exif['EXIF']['DateTimeOriginal'];
					$imageData["#exifExposureBiasValue#"] = $exif['EXIF']['ExposureBiasValue'];
					$imageData["#exifMeteringMode#"] = $exif['EXIF']['MeteringMode'];
					$imageData["#exifFlash#"] = $exif['EXIF']['Flash'];
					$imageData["#exifExposureMode#"] = $exif['EXIF']['ExposureMode'];
					$imageData["#exifWhiteBalance#"] = $exif['EXIF']['WhiteBalance'];
					$imageData["#exifLens#"] = $exif['MAKERNOTE']['UndefinedTag:0x0095'];
					$imageData["#exifOwnerName#"] = $exif['MAKERNOTE']['OwnerName'];
					$imageData["#exifFocalLength#"] = intval($exif['EXIF']['FocalLength']).' mm';
					$imageData["#exifCopyright#"] = $exif['COMPUTED']['Copyright'];
				}
			}
			
			// Replace Image Caption Placeholders.
			foreach ($imageData as $key => $value) {
			    $slideTitle = str_replace($key, $value, $slideTitle);
			}
			
			// Update the Slides String.	
			$hvSliderSlides_%id% .= "{image:'./".$image."', title:'".$slideTitle."'},";	
			
			// Clear the Image Data Arrays.
			if (isset($iptc)) { unset($iptc); }
			if (isset($exif)) { unset($exif); }
			if (isset($imageData)) { unset($imageData); }
		}
	}
}

// Set the Slides Variable, add error message in case no images are found.
if($hvSliderSlides_%id% == "") {
	$hvSliderSlides_%id% = "[{image:'%siteAssetPath%/hv_slider_assets/blank.gif', title:'No images files found in \"".$hvSliderMainImagesFolder_%id%."\"'}]";
} else {
	$hvSliderSlides_%id% = "[".rtrim($hvSliderSlides_%id%, ',')."]";	
}
?>
%[else]%<ul><li>
<?php

// PHP Requirements Check.
$hvSliderSlides_%id% = "[{image:'%siteAssetPath%/hv_slider_assets/blank.gif', title:'PHP Requirements Check...'}]";

echo "PHP version ". phpversion() . " detected";
if (version_compare(PHP_VERSION, '5.3.0', '<')) {
    echo ", minimal required version is 5.3.0<br />\n";
}
?></li><li><?php 
if (function_exists('glob')) {
   echo "GLOB enabled\n";
} else {
    echo "GLOB disabled, this is required to get the images from the resource folder\n";
}
?></li><li><?php 
if (function_exists('pathinfo')) {
   echo "Pathinfo enabled\n";
} else {
    echo "Pathinfo disabled, this is required to get specific image file information\n";
}
?></li><li><?php 
if (function_exists('getimagesize')) {
   echo "Getimagesize enabled\n";
} else {
    echo "Getimagesize disabled, this is required to read specific image \"information\"\n";
}
?></li><li><?php 
if (function_exists('iptcparse')) {
   echo "IPTC Parse enabled\n";
} else {
    echo "IPTC Parse disabled, this is required to read this specific image \"caption information\"\n";
}
?></li><li><?php 
if (function_exists('read_exif_data')) {
   echo "Read EXIF data enabled\n";
} else {
    echo "Read EXIF data disabled, this is required to read this specific image \"caption information\"\n";
}
?>
</ul>
<p><br />Please contact your hosting provider in case you are using an outdated PHP version or some of the required PHP features are disabled.</p>%[endif]%
%[endif]%%[if preview]%
<?php $hvSliderSlides_%id% = "[{image:'%siteAssetPath%/hv_slider_assets/blank.gif', title:'PUBLISH YOUR WEBSITE TO SEE THE SLIDESHOW'}]"; ?>
%[endif]%
<script type="text/javascript">
jQuery(function($){
	$.supersized({slideshow:%id=onoff%, autoplay:%id=autoplay%, start_slide:%id=start_slide%, stop_loop:%id=stop_loop%, random:%id=random%, slide_interval:%id=slide_interval%, transition_speed:%id=transition_speed%, transition:%id=transition%, new_window:1, pause_hover:%id=pause_hover%, progress_bar:%id=progress_bar%, keyboard_nav:%id=keyboard_nav%, image_protect:%id=image_protect%, fit_always:%id=fit_always%, fit_portrait:%id=fit_portrait%, fit_landscape:%id=fit_landscape%, min_width:%id=min_width%, min_height:%id=min_height%, vertical_center:%id=vertical_center%, horizontal_center:%id=horizontal_center%, slide_links:'blank', performance:1, thumb_links:1, thumbnail_navigation:1, slides:<?php echo $hvSliderSlides_%id%; ?>});
	%[if %("%id=phpCheckRequirements%"=="disabled")%]%$('#%id%').remove();%[endif]%
});
</script>
<!-- End of HV Slider stack -->
%[endif]%